/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.activity;

import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionLifeListener;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;

public class ActivityManager {
    private static final String TRACE_MASKT = "XTIFACTT";
    private static final String TRACE_MASKF = "XTIFACTF";
    private static final String PASSWORD_PROMPT_TASK_ATTR_IN_SESSION = "activity.passwordPromptTask";
    private static final String LAST_REAUTHENTICATION_ATTR_IN_SESSION = "activity.lastReAuthenticationTime";
    private static final long MAX_TIMEOUT = Long.MAX_VALUE;
    private static final long DISCONNECTED_SESSION_TIMEOUT = 172800000L;
    private static final long PROTO_SESSION_TIMEOUT = 1800000L;
    private static final long LOSS_OF_CONNECTIVITY_TIMEOUT = 90000L;
    private static final long WAIT_FOR_LOGOFF_TASK_TIMEOUT = 300000L;
    private static final long WAIT_FOR_MAIN_UI_TIMEOUT = 900000L;
    private static ActivityManager activityManager;
    private Listener listener;
    private List trackedSessions = new ArrayList(10);
    private boolean timerThreadRunning;
    private final String LAUNCH_CLEANUP_SCRIPT = "window.open(\"" + ServletRuntime.getRuntime().getHMCContextPath() + "/tasks/defunctCleanup.jsp\", \"\", " + "\"width=400,height=300,top=\"+((screen.availHeight-300)/2)+\"," + "left=\"+((screen.availWidth-400)/2)+\"scrollbars=yes,resizable=yes\");";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$servlet$activity$ReauthenticationTask;

    public static synchronized ActivityManager getActivityManager() {
        if (activityManager == null) {
            activityManager = new ActivityManager();
        }
        return activityManager;
    }

    private ActivityManager() {
        this.listener = new Listener();
        HMCSession.addHMCSessionLifeListener(this.listener);
        Iterator iterator = HMCSession.getAllSessions().iterator();
        while (iterator.hasNext()) {
            HMCSession session = (HMCSession)iterator.next();
            this.startTrackingSession(session);
        }
    }

    public void markActive(HMCSession session) {
        session.setLastUserActivityTime(new Date());
        this.updateTracking(session);
    }

    public void reexamine(HMCSession session) {
        this.updateTracking(session);
    }

    void reauthenticationStarted(HMCSession session, PresentationTask reauthTask) {
        session.setSessionAttribute(PASSWORD_PROMPT_TASK_ATTR_IN_SESSION, new WeakReference<PresentationTask>(reauthTask));
        this.updateTracking(session);
    }

    void reauthenticationFinished(HMCSession session, int result) {
        session.removeSessionAttribute(PASSWORD_PROMPT_TASK_ATTR_IN_SESSION);
        if (result == 1) {
            session.setSessionAttribute(LAST_REAUTHENTICATION_ATTR_IN_SESSION, new Date());
        } else if (result == 2) {
            this.forceReAuthenticationFailureDisconnect(session);
        }
        this.updateTracking(session);
    }

    private synchronized void startTrackingSession(HMCSession session) {
        if (this.containsSession(session)) {
            return;
        }
        TrackingEntry entry = new TrackingEntry(session);
        session.addHMCSessionListener(this.listener);
        this.calculateTrackingTime(entry);
        this.insertTrackingEntry(entry);
    }

    private synchronized void stopTrackingSession(HMCSession session) {
        if (this.removeSession(session)) {
            session.removeHMCSessionListener(this.listener);
        }
    }

    private synchronized void updateTracking(HMCSession session) {
        int index = this.indexOfSession(session);
        if (index == -1) {
            return;
        }
        TrackingEntry entry = (TrackingEntry)this.trackedSessions.get(index);
        long oldtime = entry.getTrackingActionTime();
        this.calculateTrackingTime(entry);
        long newtime = entry.getTrackingActionTime();
        if (oldtime == newtime) {
            return;
        }
        if (index > 0 && newtime < ((TrackingEntry)this.trackedSessions.get(index - 1)).getTrackingActionTime() || index < this.trackedSessions.size() - 1 && newtime > ((TrackingEntry)this.trackedSessions.get(index + 1)).getTrackingActionTime()) {
            this.trackedSessions.remove(index);
            this.insertTrackingEntry(entry);
        } else {
            this.maybeCreateTimerThread(entry, index);
        }
    }

    private void calculateTrackingTime(TrackingEntry entry) {
        PresentationTask task;
        long idleTimeout;
        long now = System.currentTimeMillis();
        HMCSession session = entry.getSession();
        if (session == null) {
            entry.setTrackingActionTime(now);
            return;
        }
        Date testTime = session.getDisconnectionTime();
        if (testTime != null) {
            entry.setTrackingActionTime(testTime.getTime() + 172800000L);
            Date lossOfConnectivityTime = session.getLossOfConnectivityTime();
            if (lossOfConnectivityTime != null && session.getCreationTime().equals(lossOfConnectivityTime)) {
                entry.setTrackingActionTime(testTime.getTime() + 1800000L);
            }
            Trace.trace(TRACE_MASKT, "Disconnected session " + session.getSessionId() + " times out in " + this.formatTimeout(entry));
            return;
        }
        testTime = session.getLossOfConnectivityTime();
        if (testTime != null) {
            long logoffTaskTimeout;
            long lossTimeout = testTime.getTime() + 90000L;
            Date userClosedMainUITime = session.getUserClosedMainUIWindowTime();
            if (userClosedMainUITime != null && (logoffTaskTimeout = userClosedMainUITime.getTime() + 300000L) > lossTimeout) {
                lossTimeout = logoffTaskTimeout;
            }
            if (session.getCreationTime().equals(testTime)) {
                lossTimeout = testTime.getTime() + 900000L;
            }
            entry.setTrackingActionTime(lossTimeout);
            Trace.trace(TRACE_MASKT, "Lost connectivity session " + session.getSessionId() + " times out in " + this.formatTimeout(entry));
            return;
        }
        long timeout = Long.MAX_VALUE;
        if (!CommonSystem.getCommonSystem().isLocationUnified()) {
            entry.setTrackingActionTime(timeout);
            return;
        }
        ClientUserContext userContext = session.getUserContext();
        if (userContext == null) {
            entry.setTrackingActionTime(timeout);
            return;
        }
        String userid = userContext.getUserName();
        User user = this.getUserObject(entry, userid);
        if (user == null) {
            entry.setTrackingActionTime(timeout);
            return;
        }
        int idleMinutes = user.getIdleTimeOut();
        if (idleMinutes != 0 && (idleTimeout = session.getLastUserActivityTime().getTime() + (long)idleMinutes * 60L * 1000L) < timeout) {
            timeout = idleTimeout;
            Trace.trace(TRACE_MASKT, "Idle timeout for session " + session.getSessionId() + " is in " + this.formatTimeout(timeout));
        }
        if ((task = this.getPasswordPromptTask(session)) != null) {
            long giveUpOnPasswordTimeout = task.getStartTime().getTime() + (long)user.getVerifyTimeOut() * 60L * 1000L;
            if (giveUpOnPasswordTimeout < timeout) {
                timeout = giveUpOnPasswordTimeout;
                Trace.trace(TRACE_MASKT, "Timeout waiting for reauthentication for session " + session.getSessionId() + " is in " + this.formatTimeout(timeout));
            }
        } else {
            long needReAuthTime;
            int sessionTimeoutMinutes = user.getSessionTimeOut();
            if (sessionTimeoutMinutes != 0 && (needReAuthTime = this.getLastReAuthenticationTime(session).getTime() + (long)sessionTimeoutMinutes * 60L * 1000L) < timeout) {
                timeout = needReAuthTime;
                Trace.trace(TRACE_MASKT, "Timeout until reauthentication needed for session " + session.getSessionId() + " is in " + this.formatTimeout(timeout));
            }
        }
        if (timeout == Long.MAX_VALUE) {
            Trace.trace(TRACE_MASKT, "No activity timeout necessary for session " + session.getSessionId());
        }
        entry.setTrackingActionTime(timeout);
    }

    private synchronized int indexOfSession(HMCSession session) {
        int size = this.trackedSessions.size();
        for (int i = 0; i < size; ++i) {
            TrackingEntry entry = (TrackingEntry)this.trackedSessions.get(i);
            if (session != entry.getSession()) continue;
            return i;
        }
        return -1;
    }

    private boolean containsSession(HMCSession session) {
        return this.indexOfSession(session) != -1;
    }

    private synchronized boolean removeSession(HMCSession session) {
        int index = this.indexOfSession(session);
        if (index == -1) {
            return false;
        }
        this.trackedSessions.remove(index);
        if (this.timerThreadRunning && index == 0) {
            this.notifyAll();
        }
        return true;
    }

    private synchronized void insertTrackingEntry(TrackingEntry entry) {
        int position = Collections.binarySearch(this.trackedSessions, entry);
        if (position < 0) {
            position = -(position + 1);
        }
        this.trackedSessions.add(position, entry);
        this.maybeCreateTimerThread(entry, position);
    }

    private synchronized void maybeCreateTimerThread(TrackingEntry entry, int position) {
        if (this.timerThreadRunning) {
            if (position == 0) {
                this.notifyAll();
            }
            return;
        }
        if (entry.getTrackingActionTime() == Long.MAX_VALUE) {
            return;
        }
        Thread timerThread = new Thread(new Runnable(){

            public void run() {
                ActivityManager.this.manageTimeouts();
            }
        }, "HMC session activity timeout manager");
        timerThread.setDaemon(true);
        timerThread.start();
        this.timerThreadRunning = true;
    }

    private PresentationTask getPasswordPromptTask(HMCSession session) {
        WeakReference taskReference = (WeakReference)session.getSessionAttribute(PASSWORD_PROMPT_TASK_ATTR_IN_SESSION);
        if (taskReference == null) {
            return null;
        }
        PresentationTask task = (PresentationTask)taskReference.get();
        if (task == null || task.getPanelModelTaskPortal().isTaskEnded()) {
            session.removeSessionAttribute(PASSWORD_PROMPT_TASK_ATTR_IN_SESSION);
            return null;
        }
        return task;
    }

    private Date getLastReAuthenticationTime(HMCSession session) {
        Date lastAuth = session.getConnectionTime();
        Date lastPrompt = (Date)session.getSessionAttribute(LAST_REAUTHENTICATION_ATTR_IN_SESSION);
        if (lastPrompt != null && lastPrompt.after(lastAuth)) {
            lastAuth = lastPrompt;
        }
        return lastAuth;
    }

    private String formatTimeout(TrackingEntry entry) {
        long millis = entry.getTrackingActionTime();
        return this.formatTimeout(millis);
    }

    private String formatTimeout(long millis) {
        if ((millis -= System.currentTimeMillis()) < 1000L) {
            return Long.toString(millis) + " milliseconds";
        }
        double units = millis / 1000L;
        if (units < 60.0) {
            return Double.toString(units) + " seconds";
        }
        if ((units /= 60.0) < 60.0) {
            return Double.toString(units) + " minutes";
        }
        if ((units /= 60.0) <= 48.0) {
            return Double.toString(units) + " hours";
        }
        return Double.toString(units / 24.0) + " days";
    }

    private synchronized void manageTimeouts() {
        ArrayList<TrackingEntry> entriesToRequeue = new ArrayList<TrackingEntry>(10);
        while (true) {
            TrackingEntry entry;
            long now;
            long dueTime = now = System.currentTimeMillis();
            Iterator iterator = this.trackedSessions.iterator();
            while (iterator.hasNext() && now >= (dueTime = (entry = (TrackingEntry)iterator.next()).getTrackingActionTime())) {
                iterator.remove();
                boolean requeue = this.processTimeout(entry);
                if (!requeue) continue;
                entriesToRequeue.add(entry);
            }
            if (!entriesToRequeue.isEmpty()) {
                iterator = entriesToRequeue.iterator();
                while (iterator.hasNext()) {
                    entry = (TrackingEntry)iterator.next();
                    this.calculateTrackingTime(entry);
                    this.insertTrackingEntry(entry);
                }
                entriesToRequeue.clear();
            }
            if (this.trackedSessions.size() == 0) {
                this.timerThreadRunning = false;
                return;
            }
            dueTime = ((TrackingEntry)this.trackedSessions.get(0)).getTrackingActionTime();
            if (dueTime == Long.MAX_VALUE) {
                this.timerThreadRunning = false;
                return;
            }
            long waitInterval = dueTime - now;
            if (waitInterval <= 0L) continue;
            try {
                this.wait(waitInterval);
            }
            catch (InterruptedException e) {
            }
        }
    }

    protected boolean processTimeout(TrackingEntry entry) {
        HMCSession session = entry.getSession();
        if (session == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        Date testTime = session.getDisconnectionTime();
        if (testTime != null) {
            long disconnectTimeout = testTime.getTime() + 172800000L;
            Date lossOfConnectivityTime = session.getLossOfConnectivityTime();
            if (lossOfConnectivityTime != null && session.getCreationTime().equals(lossOfConnectivityTime)) {
                disconnectTimeout = testTime.getTime() + 1800000L;
            }
            if (now > disconnectTimeout) {
                this.destroyOldDisconnectedSession(session);
                return false;
            }
        }
        if ((testTime = session.getLossOfConnectivityTime()) != null) {
            long logoffTaskTimeout;
            long lossTimeout = testTime.getTime() + 90000L;
            Date userClosedMainUITime = session.getUserClosedMainUIWindowTime();
            if (userClosedMainUITime != null && (logoffTaskTimeout = userClosedMainUITime.getTime() + 300000L) > lossTimeout) {
                lossTimeout = logoffTaskTimeout;
            }
            if (session.getCreationTime().equals(testTime)) {
                lossTimeout = testTime.getTime() + 900000L;
            }
            if (now > lossTimeout) {
                this.forceLossOfConnectivityDisconnect(session);
                return true;
            }
        }
        if (!CommonSystem.getCommonSystem().isLocationUnified()) {
            return true;
        }
        ClientUserContext userContext = session.getUserContext();
        String userid = userContext.getUserName();
        User user = this.getUserObject(entry, userid);
        if (user == null) {
            return true;
        }
        int idleMinutes = user.getIdleTimeOut();
        if (idleMinutes != 0 && now > session.getLastUserActivityTime().getTime() + (long)idleMinutes * 60L * 1000L) {
            this.forceIdleDisconnect(session);
            return true;
        }
        PresentationTask task = this.getPasswordPromptTask(session);
        if (task != null) {
            if (now > task.getStartTime().getTime() + (long)user.getVerifyTimeOut() * 60L * 1000L) {
                this.forceReAuthenticationDisconnect(session);
                return true;
            }
        } else {
            int sessionTimeoutMinutes = user.getSessionTimeOut();
            if (sessionTimeoutMinutes != 0 && now > this.getLastReAuthenticationTime(session).getTime() + (long)sessionTimeoutMinutes * 60L * 1000L) {
                this.requestReAuthentication(session);
                return true;
            }
        }
        return true;
    }

    protected void destroyOldDisconnectedSession(HMCSession session) {
        Trace.trace(TRACE_MASKT, "Destroying old disconnected session " + session.getSessionId());
        session.destroy();
    }

    protected void forceLossOfConnectivityDisconnect(HMCSession session) {
        Trace.trace(TRACE_MASKT, "Forcing session " + session.getSessionId() + " to disconnect due to loss of connectivity");
        session.disconnectFromWebSession(4);
    }

    protected void forceIdleDisconnect(HMCSession session) {
        Trace.trace(TRACE_MASKT, "Forcing session " + session.getSessionId() + " to disconnect due to being idle");
        HttpSession httpSession = session.getHttpSession();
        session.disconnectFromWebSession(3);
        this.launchDisconnectCleanup(session, httpSession);
    }

    protected void forceReAuthenticationDisconnect(HMCSession session) {
        Trace.trace(TRACE_MASKT, "Forcing session " + session.getSessionId() + " to disconnect due to not reauthenticating in time");
        HttpSession httpSession = session.getHttpSession();
        session.disconnectFromWebSession(5);
        this.launchDisconnectCleanup(session, httpSession);
    }

    protected void forceReAuthenticationFailureDisconnect(HMCSession session) {
        Trace.trace(TRACE_MASKT, "Forcing session " + session.getSessionId() + " to disconnect due to reauthentication failure");
        HttpSession httpSession = session.getHttpSession();
        session.disconnectFromWebSession(6);
        this.launchDisconnectCleanup(session, httpSession);
    }

    protected void requestReAuthentication(HMCSession session) {
        Trace.trace(TRACE_MASKT, "Requesting session " + session.getSessionId() + " to reauthenticate");
        try {
            PresentationTaskParms parms = new PresentationTaskParms();
            PresentationTask task = TaskLauncher.startTask(parms, (class$com$ibm$hwmca$fw$servlet$activity$ReauthenticationTask == null ? (class$com$ibm$hwmca$fw$servlet$activity$ReauthenticationTask = ActivityManager.class$("com.ibm.hwmca.fw.servlet.activity.ReauthenticationTask")) : class$com$ibm$hwmca$fw$servlet$activity$ReauthenticationTask).getName(), session, false);
            session.setSessionAttribute(PASSWORD_PROMPT_TASK_ATTR_IN_SESSION, new WeakReference<PresentationTask>(task));
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            this.reauthenticationFinished(session, 0);
            Trace.trace(TRACE_MASKT, "Exception running ReauthenticationTask to force user re-authentication.");
            Trace.trace(TRACE_MASKT, e);
        }
    }

    public void launchDisconnectCleanup(HMCSession session, HttpSession httpSession) {
        if (httpSession != null) {
            if (httpSession.getAttribute("util.defunctSessionMessage") != null) {
                return;
            }
            httpSession.setAttribute("util.defunctSessionMessage", (Object)"true");
            Trace.trace(TRACE_MASKT, "Pushing cleanup script for httpSession " + httpSession.getId());
        }
        TaskControllerQueue.getTaskControllerQueue(session).sendDisconnectedScript(this.LAUNCH_CLEANUP_SCRIPT);
    }

    private User getUserObject(TrackingEntry entry, String userid) {
        User user = entry.getUser();
        if (user != null) {
            return user;
        }
        user = User.getUser(userid);
        if (user != null) {
            entry.setUser(user);
        }
        return user;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$300(ActivityManager x0, HMCSession x1) {
        x0.startTrackingSession(x1);
    }

    static /* synthetic */ void access$500(ActivityManager x0, HMCSession x1) {
        x0.updateTracking(x1);
    }

    static /* synthetic */ void access$600(ActivityManager x0, HMCSession x1) {
        x0.stopTrackingSession(x1);
    }

    private static class TrackingEntry
    implements Comparable {
        WeakReference sessionReference;
        WeakReference userReference;
        long trackingActionTime;

        public TrackingEntry(HMCSession session) {
            this.sessionReference = new WeakReference<HMCSession>(session);
        }

        public HMCSession getSession() {
            return (HMCSession)this.sessionReference.get();
        }

        public void setUser(User user) {
            this.userReference = new WeakReference<User>(user);
        }

        public User getUser() {
            return this.userReference == null ? null : (User)this.userReference.get();
        }

        public void setTrackingActionTime(Date time) {
            this.trackingActionTime = time.getTime();
        }

        public void setTrackingActionTime(long time) {
            this.trackingActionTime = time;
        }

        public long getTrackingActionTime() {
            return this.trackingActionTime;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TrackingEntry) {
                return this == obj;
            }
            if (!(obj instanceof HMCSession)) {
                return false;
            }
            HMCSession thisSession = (HMCSession)this.sessionReference.get();
            if (thisSession == null) {
                return false;
            }
            return thisSession == obj;
        }

        public int compareTo(Object o) {
            long timediff = this.trackingActionTime - ((TrackingEntry)o).trackingActionTime;
            return timediff > 0L ? 1 : (timediff < 0L ? -1 : 0);
        }
    }

    private class Listener
    implements HMCSessionLifeListener,
    HMCSessionListener {
        private Listener() {
        }

        public void sessionCreated(HMCSession session) {
            Thread thread = new Thread(new Runnable(this, session){
                private final /* synthetic */ HMCSession val$session;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                    this.val$session = val$session;
                }

                public void run() {
                    ActivityManager.access$300(Listener.access$200(this.this$1), this.val$session);
                }
            }, "ActivityManager start tracking session " + session.getSessionId());
            thread.setDaemon(true);
            thread.start();
        }

        public void sessionRemoved(HMCSession session) {
            this.stopTrackingSessionAsync(session);
        }

        public void sessionDisconnected(HMCSession session) {
            PresentationTask task = ActivityManager.this.getPasswordPromptTask(session);
            if (task != null) {
                task.forceTaskToTerminate("Password prompt task not needed when disconnected");
                session.removeSessionAttribute(ActivityManager.PASSWORD_PROMPT_TASK_ATTR_IN_SESSION);
            }
            this.updateTrackingAsync(session);
        }

        public void sessionConnected(HMCSession session) {
            this.updateTrackingAsync(session);
        }

        public void sessionDestroyed(HMCSession session) {
            this.stopTrackingSessionAsync(session);
        }

        public void clientConnectivityLost(HMCSession session) {
            this.updateTrackingAsync(session);
        }

        public void clientConnectivityGained(HMCSession session) {
            this.updateTrackingAsync(session);
        }

        public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
        }

        private void updateTrackingAsync(HMCSession session) {
            Thread thread = new Thread(new Runnable(this, session){
                private final /* synthetic */ HMCSession val$session;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                    this.val$session = val$session;
                }

                public void run() {
                    ActivityManager.access$500(Listener.access$200(this.this$1), this.val$session);
                }
            }, "ActivityManager tracking updater for session " + session.getSessionId());
            thread.setDaemon(true);
            thread.start();
        }

        private void stopTrackingSessionAsync(HMCSession session) {
            Thread thread = new Thread(new Runnable(this, session){
                private final /* synthetic */ HMCSession val$session;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                    this.val$session = val$session;
                }

                public void run() {
                    ActivityManager.access$600(Listener.access$200(this.this$1), this.val$session);
                }
            }, "ActivityManager stop tracking session " + session.getSessionId());
            thread.setDaemon(true);
            thread.start();
        }

        static /* synthetic */ ActivityManager access$200(Listener x0) {
            return x0.ActivityManager.this;
        }
    }
}

